-- @docclass
UIActionSlot = extends(UIItem, 'UIActionSlot')

function UIActionSlot.create()
    local slot = UIActionSlot.internalCreate()
    slot.itemId = nil
    slot.words = nil
    slot.text = nil
    slot.hotkey = nil
    slot.useType = nil
    slot.autoSend = nil
    slot.parameter = nil
    slot.getTier = nil
    return slot
end

function UIActionSlot:onHoverChange(hovered)
    -- Show actionTooltip for spells, text, and items (use type)
    UIWidget.onHoverChange(self, hovered)
    if hovered and self.actionTooltip then
        g_tooltip.display(self.actionTooltip)
    elseif not hovered then
        g_tooltip.hide()
    end
end

function UIActionSlot:setActionTooltip(text)
    self.actionTooltip = text
end
