local musicFilename = 'sounds/startup'
local musicChannel = nil
if g_sounds then
    musicChannel = g_sounds.getChannel(SoundChannels.Music)
end

local function isMusicEnabled()
    if not g_settings then
        return false
    end
    local value = g_settings.getBoolean('enableMusicSound')
    return value == nil and false or value
end

function setMusic(filename)
    musicFilename = filename

    if not g_game.isOnline() then
        if musicChannel then
            musicChannel:stop()
            if isMusicEnabled() then
                musicChannel:enqueue(musicFilename, 3)
            end
        end
    end
end

function startup()
    if musicChannel then
        if isMusicEnabled() then
            musicChannel:enqueue(musicFilename, 3)
        else
            musicChannel:stop()
        end
        connect(g_game, {
            onGameStart = function()
                musicChannel:stop(3)
            end
        })
        connect(g_game, {
            onGameEnd = function()
                g_sounds.stopAll()
                if isMusicEnabled() then
                    musicChannel:enqueue(musicFilename, 3)
                end
            end
        })
    end

    -- Check for startup errors
    local errtitle = nil
    local errmsg = nil

    if g_graphics.getRenderer():lower():match('gdi generic') then
        errtitle = tr('Graphics card driver not detected')
        errmsg = tr(
            'No graphics card detected, everything will be drawn using the CPU,\nthus the performance will be really bad.\nPlease update your graphics driver to have a better performance.')
    end

    -- Show entergame
    if errmsg or errtitle then
        local msgbox = displayErrorBox(errtitle, errmsg)
        msgbox.onOk = function()
            EnterGame.firstShow()
        end
    else
        EnterGame.firstShow()
    end
    if g_app.hasUpdater() and g_sounds then
        g_sounds.setAudioEnabled(g_settings.getBoolean('enableAudio'))
    end
end

function init()
    if g_app.hasUpdater() then
        connect(g_app, {
            onUpdateFinished = startup,
        })
    else
        connect(g_app, {
            onRun = startup,
        })
    end

    if musicChannel then
        g_sounds.preload(musicFilename)
    end
end

function terminate()
    if g_app.hasUpdater() then
        disconnect(g_app, {
            onUpdateFinished = startup,
        })
    else
        disconnect(g_app, {
            onRun = startup,
        })
    end
end
