// Rarity mask shader: outputs solid u_Color with alpha from the sprite texture.

#ifdef GL_ES
precision mediump float;
#endif

varying highp vec2 v_TexCoord;
uniform sampler2D u_Tex0;
uniform lowp float u_Opacity;
uniform lowp vec4 u_Color;

void main() {
  float a = texture2D(u_Tex0, v_TexCoord).a;
  // Use u_Color.a to scale the mask alpha so callers can adjust opacity.
  gl_FragColor = vec4(u_Color.rgb, a * u_Color.a) * u_Opacity;
}
